
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:44:42 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief this file contains needed workarounds for the external application code.
   *     
   *
   *  \version extApp_CRYSParser.h#1:csrc:8
   *  \author Ohads
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

#ifdef __cplusplus
extern "C"
{
#endif

/************* Include Files ****************/ 

/* .............. CRYS level includes ................. */

/* .............. LLF level includes ................. */


/************************ Defines ******************************/

/************************ Enums ******************************/

/************************ Typedefs ******************************/


/************************ Global Data ******************************/

/************* Private function prototype ****************/

/************************ Public Functions ******************************/
/*******/
/* AES */
/*******/

CRYSError_t  DX_CRYS_AES_Block( CRYS_AESUserContext_t   *ContextID_ptr,   
								DxUint8_t               *DataIn_ptr,     
								DxUint32_t               DataInSize,     
								DxUint8_t               *DataOut_ptr );


CRYSError_t  DX_CRYS_AES( CRYS_AES_IvCounter_t       IVCounter_ptr,       
						 CRYS_AES_Key_t             Key_ptr,								
						 CRYS_AES_KeySize_t         KeySize,            
						 CRYS_AES_EncryptMode_t     EncryptDecryptFlag, 
						 CRYS_AES_OperationMode_t   OperationMode ,      
						 DxUint8_t                  is_secret_key,       
						 DxUint8_t                  *DataIn_ptr,        
						 DxUint32_t                 DataInSize,         
						 DxUint8_t                  *DataOut_ptr );


/*******/
/* DES */
/*******/
CRYSError_t  DX_CRYS_DES_Block( CRYS_DESUserContext_t   *ContextID_ptr,   
							   DxUint8_t               *DataIn_ptr,     
							   DxUint32_t               DataInSize,     
							   DxUint8_t               *DataOut_ptr );


CRYSError_t  DX_CRYS_DES(CRYS_DES_Iv_t             IV_ptr,                
						 CRYS_DES_Key_t           *Key_ptr,               
						 CRYS_DES_NumOfKeys_t      NumOfKeys,             
						 CRYS_DES_EncryptMode_t    EncryptDecryptFlag,    
						 CRYS_DES_OperationMode_t  OperationMode,         
						 DxUint8_t                *DataIn_ptr,            
						 DxUint32_t                DataInSize,            
						 DxUint8_t                *DataOut_ptr );          


/********/
/* HASH */
/********/
CRYSError_t  DX_CRYS_HASH_Update( CRYS_HASHUserContext_t  *ContextID_ptr,
								 DxUint8_t               *DataIn_ptr,
								 DxUint32_t               DataInSize );


CRYSError_t  DX_CRYS_HASH( CRYS_HASH_OperationMode_t  OperationMode,    
						  DxUint8_t                 *DataIn_ptr,    
						  DxUint32_t                 DataSize,    
						  CRYS_HASH_Result_t         HashResultBuff );



/********/
/* HMAC */
/********/
CRYSError_t  DX_CRYS_HMAC_Update( CRYS_HMACUserContext_t  *ContextID_ptr,
								 DxUint8_t               *DataIn_ptr,
								 DxUint32_t               DataInSize );


CRYSError_t  DX_CRYS_HMAC( CRYS_HASH_OperationMode_t  OperationMode,
						  DxUint8_t                   *key_ptr,
						  DxUint16_t                  keySize,
						  DxUint8_t                   *DataIn_ptr,    
						  DxUint32_t                  DataSize,    
						  CRYS_HASH_Result_t          HmacResultBuff );


/************/
/* RSA SIGN */
/************/
CRYSError_t DX_CRYS_RSA_SignUpdate(CRYS_RSAPrivUserContext_t *UserContext_ptr,
							   DxUint8_t     *DataIn_ptr,
							   DxUint32_t     DataInSize);


CRYSError_t DX_CRYS_RSA_Sign(CRYS_RSAPrivUserContext_t *UserContext_ptr,
						 CRYS_RSAUserPrivKey_t *UserPrivKey_ptr,
						 CRYS_RSA_HASH_OpMode_t hashFunc,
						 CRYS_PKCS1_MGF_t MGF,
						 DxUint16_t SaltLen,				  			      
						 DxUint8_t     *DataIn_ptr,
						 DxUint32_t     DataInSize,
						 DxUint8_t     *Output_ptr,
						 DxUint16_t    *OutputSize_ptr,
						 CRYS_PKCS1_version PKCS1_ver);


/**************/
/* RSA VERIFY */
/**************/
CRYSError_t DX_CRYS_RSA_VerifyUpdate(CRYS_RSAPubUserContext_t *UserContext_ptr,
								   DxUint8_t     *DataIn_ptr,
								   DxUint32_t     DataInSize);


CRYSError_t DX_CRYS_RSA_Verify(CRYS_RSAPubUserContext_t *UserContext_ptr,
                           CRYS_RSAUserPubKey_t *UserPubKey_ptr,
                           CRYS_RSA_HASH_OpMode_t hashFunc,
                           CRYS_PKCS1_MGF_t MGF,
                           DxUint16_t SaltLen,
                           DxUint8_t     *DataIn_ptr,
                           DxUint32_t     DataInSize,
                           DxUint8_t     *Sig_ptr,
                           CRYS_PKCS1_version PKCS1_ver);



/************/
/* ECC SIGN */
/************/
CRYSError_t DX_CRYS_ECDSA_SignUpdate( CRYS_ECDSA_SignUserContext_t  *SignUserContext_ptr,
								  DxUint8_t                     *MessageDataIn_ptr,
								  DxUint32_t                      DataInSize);


CRYSError_t DX_CRYS_ECDSA_Sign(CRYS_ECDSA_SignUserContext_t  *SignUserContext_ptr,
							CRYS_ECPKI_UserPrivKey_t      *SignerPrivKey_ptr,
							CRYS_ECPKI_HASH_OpMode_t       HashMode,
							DxUint8_t                     *MessageDataIn_ptr,
							DxUint32_t                     MessageSizeInBytes,
							DxUint8_t                     *SignatureOut_ptr,  
							DxUint32_t                    *SignatureOutSize_ptr );


/**************/
/* ECC VERIFY */
/**************/
CRYSError_t DX_CRYS_ECDSA_VerifyUpdate( CRYS_ECDSA_VerifyUserContext_t *VerifyUserContext_ptr,
								        DxUint8_t                     *MessageDataIn_ptr,
								        DxUint32_t                      DataInSize);


CRYSError_t DX_CRYS_ECDSA_Verify(CRYS_ECDSA_VerifyUserContext_t *VerifyUserContext_ptr, 
							     CRYS_ECPKI_UserPublKey_t       *UserPublKey_ptr,
							     CRYS_ECPKI_HASH_OpMode_t        HashMode,
							     DxUint8_t                      *SignatureIn_ptr,
							     DxUint32_t                      SignatureSizeBytes,
							     DxUint8_t                      *MessageDataIn_ptr, 
							     DxUint32_t                      MessageSizeInBytes  );

/*******/
/* RC4 */
/*******/
CRYSError_t  DX_CRYS_RC4_Stream( CRYS_RC4UserContext_t   *ContextID_ptr,    
								DxUint8_t               *DataIn_ptr,     
								DxUint32_t               DataInSize,     
								DxUint8_t               *DataOut_ptr );



CRYSError_t  DX_CRYS_RC4(DxUint8_t    *Key_ptr, 
						 DxUint32_t    KeySizeInBytes,
						 DxUint8_t    *DataIn_ptr, 
						 DxUint32_t    DataInSize,
						 DxUint8_t    *DataOut_ptr);          
